<?
/*
Обработчик платежей для сервиса WapKassa.Ru
Автор: Владислав (https://vk.com/shadrvlad)
*/
require_once('../core/sys.php');
require_once('../core/WapkassaClass.php');

try {
    // Инициализация класса с id сайта и секретным ключом
    $wapkassa = new WapkassaClass(WK_ID, WK_SECRET);

    // Проверка обработчика (PING)
    if ($wapkassa->ping($_POST)) {
        // возврат успешной проверки
        echo $wapkassa->successPing();
    } else {
        // Парсинг входящих параметров
        $params = $wapkassa->parseRequest($_POST);

        $params['id']; // id платежа в системе wapkassa
        $params['site_id']; // id площадки
        $params['time']; // время оплаты в unixtime
        $params['comm']; // комментарий платежа
        $params['amount']; // сумма платежа
        $params['add']; // массив с допольнительными параметрами

        // собственный код зачисления платежа на сайте
        $sql = $db->prepare('SELECT * FROM `wapkassa` WHERE `id` = ? AND `wmr` <= ? AND `time_pay` = "0" LIMIT 1');
        $sql->execute([$params['add']['id'], $params['amount']]);

        if ($sql->rowCount() > 0) {
            $pay = $sql->fetch(PDO::FETCH_ASSOC);

            $sql = $db->prepare("UPDATE `wapkassa` SET `time_pay` = ? WHERE `id` = ? LIMIT 1");
            $sql->execute([$_POST['WK_PAY_TIME'], $pay['id']]);

            $sql = $db->prepare('INSERT INTO `platform` (`url`,`time`,`status`) VALUES (?,?,?)');
            $sql->execute([$pay['url'], (time() + 86400 * $pay['day']), 'on']);
        }

        // возврат успешной обработки
        echo $wapkassa->successPayment();
    }
} catch (Exception $e) {
    // вывод ошибки
    echo 'Ошибка: ' . $e->getMessage() . PHP_EOL;
}
